const sendOk = (res) => {
  res.setHeader('Content-Type', 'application/json');
  res.end(JSON.stringify({ result: "ok" }));
}

const filterOldRecords = (obj) => {
  const now = new Date().getTime();
  
  for(key in obj)
  {
    if(now - obj[key].timestamp.getTime() > 10000)
    {
      delete obj[key];
    }
  }
}

function compareHighscores(a, b) {
  if (parseFloat(a.score) < parseFloat(b.score))
  {
    return -1;
  }
  else if(a.last_nom > b.last_nom)
  {
    return 1;
  }
  return 0;
}

module.exports = { sendOk, filterOldRecords, compareHighscores };